<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbAnonymizer Version 4.0 vBulletin 4  http://forum.golzarion.com # ||
|| # Copyright (c)2010, Golzarion. All Rights Reserved.      # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################

define('THIS_SCRIPT', 'redirector');
define('CSRF_PROTECTION', true);  
// change this depending on your filename

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('vbanonymizer');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array('vbanonymizer_main',
	'vbanonymizer_about'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
// if your page is outside of your normal vb forums directory, you should change directories by uncommenting the next line
// chdir ('/path/to/your/forums');
require_once('./global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// clean
$url = $vbulletin->input->clean(rawurldecode($_GET['url']), TYPE_NOHTML);

// check url
if ($_GET['do'] != 'about' AND !preg_match('/^(.+)\:\/\//i', $url))
{
	$_GET['do'] = 'about';
}

// redirect immediately if no delay is set
if (!empty($url) AND $_GET['do'] == 'nodelay')
{
	die('<meta http-equiv="refresh" content="0; URL=' . $url . '">');
}

// script path and navbit setup
$scriptpath = (($vbulletin->options['vbanonymizer_scriptpath']) ? $vbulletin->options['vbanonymizer_scriptpath'] : $vbulletin->options['bburl']) . '/' . $vbulletin->options['vbanonymizer_scriptname'] . '.php';
$navbits = array();

// finish up output
if ($_GET['do'] == 'about')
{
	// navbit breadcrumb
	$navbits[$parent] = $vbphrase['vbanonymizer_about'];

	// specify our template
	$templatename = 'vbanonymizer_about';
}
else
{
	// navbit breadcrumb
	$navbits[$parent] = $vbulletin->options['vbanonymizer_title'];

	// search and replace arrays
	$search = array(
		'{forum}',
		'{url}',
		'{delay}'
	);
	$replace = array(
		$vbulletin->options['bbtitle'],
		'<a href="' . $scriptpath . '?' . $vbulletin->session->vars['sessionurl'] . 'do=nodelay&amp;url=' . rawurlencode(str_replace('&amp;', '&', $url)) . '">' . $url . '</a>',
		'<span id="delay">' . $vbulletin->options['vbanonymizer_delay'] . '</span>'
	);

	// parse message
	$message = str_replace($search, $replace, $vbulletin->options['vbanonymizer_message']);

	// specify our template
	$templatename = 'vbanonymizer_main';
}

////////////////////////////////////////////////////////////////////

$navbits = construct_navbits(array('' => 'Redirecting to..... '));
$navbar = render_navbar_template($navbits);

// ###### YOUR CUSTOM CODE GOES HERE #####
$pagetitle = 'Redirecting....';

// ###### NOW YOUR TEMPLATE IS BEING RENDERED ######

$templater = vB_Template::create($templatename
);

$templater->register_page_templates();
$templater->register('navbar', $navbar);
$templater->register('pagetitle', $pagetitle);
$templater->register('message',$message);
$templater->register('url',$url);
print_output($templater->render());

///////////////////////////////////////////////////////////////////
?>
